#ifndef SEARCH_H
#define SEARCH_H
#include <gtkmm.h>

class SEARCH : public Gtk::Window{
    public:
        SEARCH();
        SEARCH(char *b_name);
        virtual ~SEARCH();
        void on_button1_click();
        class ModelColumns : public Gtk::TreeModel::ColumnRecord
        {
            public:
                ModelColumns()
                { add(sr_no); add(b_id);add(b_name);add(a_name);add(b_status); }

                Gtk::TreeModelColumn<int> sr_no;
                Gtk::TreeModelColumn<Glib::ustring> b_id;
                Gtk::TreeModelColumn<Glib::ustring> b_name;
                Gtk::TreeModelColumn<Glib::ustring> a_name;
                Gtk::TreeModelColumn<Glib::ustring> b_status;

        };

        ModelColumns columns;
        Glib::RefPtr<Gtk::ListStore> refTreeModel;
        int rowcount = 0;
};

SEARCH::SEARCH(char *b_name){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("SEARCH RESULTS");
    show();

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);

    Gtk::TreeView *treeview = Gtk::manage(new Gtk::TreeView);
    treeview->set_hexpand(true);
    treeview->set_vexpand(true);
    grid->attach(*treeview, 0, 0, 3, 1);
    refTreeModel = Gtk::ListStore::create(columns);
    treeview->set_model(refTreeModel);
    treeview->append_column("Sr. No.", columns.sr_no);
    treeview->append_column("Book ID", columns.b_id);
    treeview->append_column("Book Name", columns.b_name);
    treeview->append_column("Author Name", columns.a_name);
    treeview->append_column("Book Status", columns.b_status);

    Gtk::Button *button1 = Gtk::manage(new Gtk::Button("QUIT"));
    button1->signal_clicked().connect(sigc::mem_fun(*this, &SEARCH::on_button1_click));
    grid->attach(*button1, 1, 2, 1, 1);

    FILE *fbook;
    fbook=fopen("BOOK.txt","r");
    char b_string[100]="",s1[30],s2[30],s3[30],s4[30];
     int i,j;
     while(!feof(fbook)){
        i=j=0;
		fgets(b_string,99,fbook);
		if(feof(fbook))
            break;
		for(i=0;b_string[j]!=',';s1[i]=b_string[j],i++,j++);
		s1[i]='\0';
		for(i=0,++j;b_string[j]!=',';s2[i]=b_string[j],i++,j++);
		s2[i]='\0';
		for(i=0,++j;b_string[j]!=',';s3[i]=b_string[j],i++,j++);
		s3[i]='\0';
		for(i=0,++j;b_string[j]!=',';s4[i]=b_string[j],i++,j++);
		s4[i]='\0';
		if(strcmp(s2,b_name)==0){
        Gtk::TreeModel::Row row = *(refTreeModel->append());
        rowcount++;
        row[columns.sr_no] = rowcount;
        row[columns.b_id] = s1;
        row[columns.b_name] = s2;
        row[columns.a_name] = s3;
        if(strcmp(s4,"1")==0)
            row[columns.b_status] = "Issued";
        else
            row[columns.b_status] = "Available";
        }
	}
	fclose(fbook);
	show_all_children();
    vbox->show_all();

}

void SEARCH::on_button1_click(){
    hide();
}


SEARCH::~SEARCH(){
}
#endif;
